#include <DHT.h>                                                  //Βιβλιοθήκη αισθητήρα θερμοκρασίας/υγρασίας αέρα (DHT11)

#define DHTPIN 5                                                  // Δήλωση της Θύρας δεδομένων του αισθητήρα (π.χ η θύρα εδώ είναι η D5)
#define DHTTYPE DHT11                                             // Τύπος αισθητήρα DHT11   (οι τύποι είναι ο DHT11:γαλάζιος και ο DHT22:λευκός με μεγαλύτερη ακρίβεια)

DHT dht(DHTPIN, DHTTYPE);                                         // έναρξη αισθητήρα DHT

void setup() 
{
  Serial.begin(9600);                                             // Εκκίνηση της σειριακής επικοινωνίας
  dht.begin();                                                    // Εκκίνηση του αισθητήρα
}

void loop() 
{
  
  float humidity = dht.readHumidity();                              // Ανάγνωση υγρασίας
  float temperature = dht.readTemperature();                        // Ανάγνωση θερμοκρασίας

  
  if (isnan(humidity) || isnan(temperature)) 
  {
    Serial.println("Σφάλμα ανάγνωσης από τον αισθητήρα DHT11");     // Έλεγχος αν η ανάγνωση από τον αισθητήρα ήταν επιτυχής
  } 
  
  else 
  {
    Serial.print("Υγρασία: ");                                      // Εμφάνιση της θερμοκρασίας και υγρασίας στο Σειριακό Παράθυρο (Tools/Serial Monitor)
    Serial.print(humidity);
    Serial.print(" %,  ");

    Serial.print("Θερμοκρασία: ");
    Serial.print(temperature);
    Serial.println(" °C");
  }

  delay(500);                                                       // Καθυστέρηση 0.5 δευτερολέπτων
}
